#!/usr/bin/env perl

use strict;
use warnings;
use FindBin qw($Bin);
use lib ("$Bin/../TEBA/PHParse", "$Bin/../TEBA");

use PHParser;

use Getopt::Std;
my %opts = ();


if (!getopts("thj", \%opts) || $opts{h}) {
    print STDERR "phparse.pl [-tjh] [files...]\n",
	"  -t: treat the input as HTML, including PHP tags <?php ... ?>\n",
	"  -j: output AST of JSON format\n",
	"  -h: help.\n";
    exit(1);
}

$| = 1;

my $parser = PHParser->new();
if ($opts{t}) {
    $parser = $parser->require_php_tag();
}
if ($opts{j}) {
    $parser = $parser->as_json();
}

my $src = join("", <>);
print $parser->parse($src);
