#!/usr/bin/env perl
# 
# Copyright (c) 2009-2025 The TEBA Project. All rights reserved.
# 
# Redistribution and use in source, with or without modification, are
# permitted provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# Author: Atsuhi Yoshida


use strict;
use warnings;

use GraphViz;

# for debug
#use Data::Dumper;

use FindBin qw($Bin);
use lib "$Bin/../TEBA";

use CFG;


use Getopt::Std;

my %opts = ();
if (!getopts("SLeEhjlc", \%opts) || $opts{h}) {
    print STDERR "ast2cfg.pl [-eESh] [json-based-ast-file]\n",
	"  -S: statement level cfg.\n",
	"  -L: logical expression level cfg.\n",
	"  -e: expression level cfg. (default)\n",
	"  -E: expression level cfg with expression nodes.\n",
	"  -l: removes logical operators.\n",
	"  -c: evaluate literal conditions in control statements\n",
	"  -h: help.\n";
    exit(1);
}
# option -j exists for compatibilty only.

# mapping to the options for CFG.pm
$opts{literal_cond} = $opts{c};
$opts{abst_level} = $opts{S} ? "S" : $opts{L} ? "L" : "E";
$opts{remove_logical_op} = $opts{l};
$opts{with_expr_node} = $opts{E};

my $ast = AST::NODE->build_from_json_text(join('', <>));
my $cfg = CFG->new($ast, \%opts);

print $cfg->to_json();

