#!/usr/bin/env perl
# 
# Copyright (c) 2009-2025 The TEBA Project. All rights reserved.
# 
# Redistribution and use in source, with or without modification, are
# permitted provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# Author: Atsuhi Yoshida


# 良いプログラムを書くためのおまじない。
use warnings;
use strict;

# debug 用
use Data::Dumper;
#use Carp qw(confess);
#$SIG{__DIE__} = \&confess;


# TEBA のライブラリの読み込みパスの設定 (TEBA のパッケージに入っているコマンド用)
# TEBA のパッケージに入っていない場合は PERLLIB 設定する必要がある。
use FindBin qw($Bin);
use lib "$Bin/../TEBA";

# TEBA の AST, PDG モジュールを使用。
use AST;
use PDG;

# オプションの設定
use Getopt::Std;

my %opts = ();
if (!getopts("h", \%opts) || $opts{h}) {
    print STDERR "pdg2dot.pl [-h] [TEBA AST JSON file]\n",
#        "  -d: debug mode.\n",
        "  -h: help.\n";
    exit(1);
}

# JSON 形式の AST を読み込む (PDG を生成済みのもの)
my $ast = AST::NODE->build_from_json_text(join('', <>));
my $pdg = PDG->new->load($ast);

print $pdg->pdg2dot;
